#! /bin/sh

#wxWidgets: OSX Lion, Mountain Lion, Mavericks

#adapter les variables WXVERSION, WXVER et WXPATH

#version de wxWidgets:
WXVERSION=3.0.2
#WXVER=2.9 si WXVERSION=2.9.5, WXVER=3.0 si WXVERSION=3.0.x
WXVER=3.0

#chemin de la distribution wxWidgets
WXPATH=$HOME/Documents/wxWidgets/wxWidgets-$WXVERSION

DEFINES="-D__WXOSX_COCOA__ -D_FILE_OFFSET_BITS=64 -DWX_PRECOMP -DWXUSINGDLL"
INCLUDES="-I$WXPATH -I$WXPATH/lib/wx/include/osx_cocoa-unicode-$WXVER -I$WXPATH/include"

g++ -mmacosx-version-min=10.7 -c -Wall -Wundef -Wunused-parameter -Wno-ctor-dtor-privacy -Woverloaded-virtual -Wno-deprecated-declarations -O2 -fno-strict-aliasing -fno-common -fvisibility=hidden -fvisibility-inlines-hidden $DEFINES $INCLUDES ../../sources/wx/*.cpp ../../sources/All/*.cpp


FRAMEWORKS="-framework IOKit -framework Carbon -framework Cocoa -framework AudioToolbox -framework System -framework OpenGL"
LIBS="-lwx_osx_cocoau_stc-$WXVER -lwx_osx_cocoau_core-$WXVER -lwx_baseu-$WXVER -lwxscintilla-$WXVER -framework WebKit -lwxregexu-$WXVER -framework IOKit -framework AudioToolbox -lz -lpthread -liconv"

g++ -mmacosx-version-min=10.7 -o WinCaml *.o $FRAMEWORKS -L$WXPATH/lib $LIBS


rm *.o
mv WinCaml WinCaml5/WinCaml.app/Contents/MacOS
test -d WinCaml5/WinCaml.app/Contents/MacOS/ocaml || mkdir WinCaml5/WinCaml.app/Contents/MacOS/ocaml
cp -Rf ../../caml/ocaml/mac WinCaml5/WinCaml.app/Contents/MacOS/ocaml
cp -Rf ../../caml/ocaml/htmlman WinCaml5/WinCaml.app/contents/MacOS/ocaml
cp -Rf ../../caml/caml-light  WinCaml5/WinCaml.app/contents/MacOS/
rm -f WinCaml5/WinCaml.app/contents/MacOS/caml-light/bin/caml*
rm -f WinCaml5/WinCaml.app/contents/MacOS/caml-light/bin/lin*
chmod +x WinCaml5/WinCaml.app/contents/MacOS/caml-light/bin/mactoplevel*
cp -Rf ../../caml/exemples WinCaml5

