/*
Program WinCaml: Graphical User Interface
for interactive use of Caml-Light and Ocaml.
Copyright (C) 2005-2017 Jean Mouric 35700 Rennes France
email: jean.mouric@orange.fr

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>. 
*/

// File CFrame.h

#include "platform.h"

class CChildFrame;

class CFrame : public CMDIFrame
{
	friend class CChildFrame;

	deque<wstring> recentFiles;

	void fontDialog(CFont* font, bool input);
	void setDefaultSettings();
	void onClose();
	void onCommand(int cmd);
	void onDrop();
	void onFileNew();
	void onFileOpen();
	bool reviewChanges();
	void saveConfig();
	void setConfig();
	void updateMenus();

public:
	//begin config--------------------------------------------

	bool IndentWithTabs;
	bool IndentAfterIn;
	bool IndentFilters;
	bool UseOCamlIndenter;
	int SpaceCountPerTab;

	bool VerticalBar;
	int xSplit;
	int ySplit;

	int InputFontSize;
	bool InputFontBold;
	bool InputFontItalic;
	int OutputFontSize;
	bool OutputFontBold;
	bool OutputFontItalic;
	wstring InputFontName;
	wstring OutputFontName;

	bool WrapInput;
	bool WrapOutput;

	int SplitterViewMode;

	bool SyntaxColoring;

	int OutputMode;

	unsigned long InputCommandBackground;
	unsigned long OutputCommandForeground;
	unsigned long InputBufferBackground;
	unsigned long CommentColor;
	unsigned long DelimiterColor;
	unsigned long KeywordColor;
	unsigned long NumberColor;
	unsigned long OperatorColor;
	unsigned long StringColor;
	unsigned long OtherColor;

	int PreferredEncoding;
	bool AutomaticEncoding;

	int CamlTop;
	bool StartNow;

	//end config--------------------------------------------

	bool closing;
	CFont *font1, *font2;
	int newFileCount;
	bool restoreDefaults;

	CFrame();
	~CFrame();
	void clearFont(CFont*& font);
	void openFile(const wstring& fileName);
	void openFiles(deque<wstring>& files);
	void setConfig(CChildFrame* childFrame);
	void updateOutputMenu(int cmd);
	void updateRecentFilesMenus();
	void updateRecentFiles(wstring fileName, bool fileNotFound);
	void updateSplitViewMenu();
};

