/*
Program WinCaml: Graphical User Interface
for interactive use of Caml-Light and Ocaml.
Copyright (C) 2005-2017 Jean Mouric 35700 Rennes France
email: jean.mouric@orange.fr

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>. 
*/

// File CUndoManager.h

#include <deque>
#include <string>
#include "platform.h"

class CInput;

using namespace std;

enum
{
	UR_NONE = 0,
	UR_TYPING,
	UR_CUT,
	UR_PASTE,
	UR_INDENT,
	UR_INCLUDE,
	UR_REPLACE
};

class CUndoManager;

class CUndoRecord
{
	friend class CUndoManager;
	int type;
	size_t offs;
	size_t selStart1, selStart2, selEnd1, selEnd2;
    wstring replacingString;
	wstring replacedString;
	CUndoRecord(int t, size_t o, wstring s1, wstring s2)
	{
		type = t;
		offs = o;
		replacingString = s1;
		replacedString = s2;
	}
};
class CUndoManager
{
	CInput* textEdit;
	deque<CUndoRecord*>* v;
	unsigned int i;
	int type;
	bool newType;
	bool busy;
	size_t selStart, selEnd;
public:
	CUndoManager(CInput* te);
	~CUndoManager();
	void add(size_t offs, wstring replacingString, wstring replacedString);
	void merge(size_t offs, wstring replacingString, wstring replacedString);
	void undo();
	void redo();
	int getUndoType();
	int getRedoType();
	void setType(int t);
	int getType();
	void setSelection();
	void start();
	void stop();
};

