/*
 Program WinCaml: Graphical User Interface
 for interactive use of Caml-Light and Ocaml.
 Copyright (C) 2005-2017 Jean Mouric 35700 Rennes France
 email: jean.mouric@orange.fr
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

// File main.cpp

#include "CFrame.h"

const wstring appName = L"WinCaml";
const wstring version1 = L"5.9";

#ifdef _WX_PLATFORM_

const wstring version = L"wx5_9";
#ifdef __WXMSW__
int WINAPI WinMain(HINSTANCE, HINSTANCE, PSTR, int)
{
	CMDIApp app;
#else
int main(int argc, char* argv[])
{
    CMDIApp app(argc, argv);
#endif
#ifndef __WXMAC__
   if (app.alreadyExists) return 0;
#endif
    return app.run(new CFrame());
}
    
#else
    
#ifdef _WINDOWS_PLATFORM_    
#include <Windows.h>
const wstring version = L"5_9";
int WINAPI WinMain(HINSTANCE, HINSTANCE, PSTR, int)
{
	CMDIApp app;
#else
const wstring version = L"Qt5_9";
int main(int argc, char *argv[])
{
    CMDIApp app(argc, argv);
#endif
    if (app.alreadyExists) return 0;
    CFrame frame;
    return app.run(frame);
}
    
#endif
