#!/bin/sh

#wxWidgets, Linux 64 bit, gtk2

#adapter les variables WXVERSION, WXVER et WXPATH

#version de wxWidgets:
WXVERSION=3.1.1
#WXVER=2.9 si WXVERSION=2.9.5, WXVER=3.0 si WXVERSION=3.0.x
WXVER=3.1

#chemin de la distribution wxWidgets
WXPATH=$HOME/wxWidgets-$WXVERSION

#libxxf86vm-dev: X11 XFree86 video mode extension library (si attendue)
#X11EXT=-lXxf86vm
X11EXT=

DEFINES="-D__WXGTK__ -D_FILE_OFFSET_BITS=64 -DWX_PRECOMP"

INCLUDES="-I. -I$WXPATH/lib/wx/include/gtk2-unicode-static-$WXVER -I$WXPATH/include -I/usr/include/gtk-2.0 -I/usr/lib/x86_64-linux-gnu/gtk-2.0/include -I/usr/include/atk-1.0 -I/usr/include/cairo -I/usr/include/gdk-pixbuf-2.0 -I/usr/include/pango-1.0 -I/usr/include/gio-unix-2.0/ -I/usr/include/glib-2.0 -I/usr/lib/x86_64-linux-gnu/glib-2.0/include -I/usr/include/pixman-1 -I/usr/include/freetype2 -I/usr/include/libpng12 -I/usr/include/gtk-unix-print-2.0"

g++ -c $DEFINES -Wall -Wundef -Wunused-parameter -Wno-ctor-dtor-privacy -Woverloaded-virtual -O2 -pthread -fno-strict-aliasing -fvisibility=hidden -fvisibility-inlines-hidden $INCLUDES ../../sources/wx/*.cpp ../../sources/All/*.cpp

LIBS="-L$WXPATH/lib -lwx_gtk2u_stc-$WXVER -lwx_gtk2u_core-$WXVER -lwx_baseu-$WXVER -lwxscintilla-$WXVER -lgtk-x11-2.0 -lgdk-x11-2.0 -latk-1.0 -lgio-2.0 -lpangoft2-1.0 -lpangocairo-1.0 -lgdk_pixbuf-2.0 -lcairo -lpango-1.0 -lfreetype -lfontconfig -lgobject-2.0 -lgthread-2.0 -lrt -lglib-2.0 -lX11 $X11EXT -lSM -lpng -lz  -lwxregexu-$WXVER -ldl -lm"

g++ -o WinCaml *.o -Wl,-rpath,$WXPATH/lib -pthread -L$WXPATH/lib $LIBS

rm *.o
test -d WinCaml6 || mkdir WinCaml6
test -d WinCaml6/ocaml || mkdir WinCaml6/ocaml
mv WinCaml WinCaml6
cp -Rf ../../caml/ocaml/linux WinCaml6/ocaml
cp -Rf ../../caml/doc WinCaml6
cp -Rf ../../caml/caml-light  WinCaml6
#rm -f WinCaml6/caml-light/bin/caml*
#rm -f WinCaml6/caml-light/bin/mac*
chmod +x WinCaml6/caml-light/bin/lin*
cp -Rf ../../caml/exemples WinCaml6

cp a/WinCamlIcon.png WinCaml6
test -d "$HOME"/WinCaml6 && rm -rf "$HOME"/WinCaml6
mv WinCaml6 "$HOME"
cp a/WinCaml.txt "$HOME"/WinCaml.desktop
echo Exec="$HOME"/WinCaml6/WinCaml %F >> "$HOME"/WinCaml.desktop
echo Icon="$HOME"/WinCaml6/WinCamlIcon.png >> "$HOME"/WinCaml.desktop
echo Path="$HOME"/WinCaml6 >> "$HOME"/WinCaml.desktop

