/*
Program WinCaml: Graphical User Interface
for interactive use of Caml-Light and Ocaml.
Copyright (C) 2005-2018 Jean Mouric 35700 Rennes France
email: jean.mouric@orange.fr

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>. 
*/

// File Utils.h

#include <string>
#include "platform.h"

using namespace std;

size_t commonPrefix(const wstring& s1, const wstring& s2);
size_t commonSuffix(const wstring& s1, const wstring& s2);
int mulDiv(int a, int b, int c);
int removeComments(wstring& str);
void trim(wstring& str);

template<class T> void tuneEndOfLines(basic_string<T, char_traits<T>, allocator<T> > &str, int enc = ENCODING_UNIX)
{
	const T cr = 13;
	const T lf = 10;
	basic_string<T, char_traits<T>, allocator<T> > nl;
	if (enc == ENCODING_WIN)
	{
		nl += cr;
		nl += lf;
	}
	else nl += lf;

	size_t a = nl.length();
	size_t i = 0;
	size_t l = str.length();
	while (i < l)
	{
		switch(str[i])
		{
		case cr:
			if (i < l - 1 && str[i + 1] == lf)
			{
				str = str.replace(i, 2, nl);
				i += a;
				l += a - 2;
			}
			else
			{
				str = str.replace(i, 1, nl);
				i += a;
				l += a - 1;
			}
			break;
		case lf:
			str = str.replace(i, 1, nl);
			i += a;
			l += a - 1;
			break;
		default: i++;
			break;
		}
	}
}
