(* renvoie true si le nombre de Mersenne 2^p - 1 est premier, false sinon *)
let est_premier_mersenne p =
	Printf.printf "test de 2^%d - 1\n" p;
	print_string "patienter...";
	print_newline ();
	let mersenne = Z.(one lsl p - one) in
		let s = ref Z.(of_int 4) in
			for i = 1 to p - 2 do
				if i mod 10000 = 0 then
				(
					Printf.printf "%d" i;
					print_newline ()
				);
				s := Z.((!s * !s - of_int 2) mod mersenne)
			done;
			Z.(equal !s zero)
;;	

(* exemple 1 : Mersenne n 24 (1971) : 2^19937 - 1 est premier *)
let t1 = Sys.time () in
	let res = est_premier_mersenne 19937 in
		let t2 = Sys.time () in
			Printf.printf "%b , %0.2f s\n" res (t2 -. t1)
;;

(* exemple 2 : Mersenne n 31 (1985) : 2^216091 - 1 est premier *)
let t1 = Sys.time () in
	let res = est_premier_mersenne 216091 in
		let t2 = Sys.time () in
			Printf.printf "%b , %0.2f s\n" res (t2 -. t1)
;;

(*
let print_mersenne p = Printf.printf "%a\n" Z.output Z.(one lsl p - one);;
print_mersenne 19937;;
*)