(*
#use "topfind";;
#list;;
#require "domainslib";;
#require "unix";;
*)
let n = 42;;

let rec fib n = if n < 2 then 1 else fib (n - 1) + fib (n - 2);;

module T = Domainslib.Task;;

let rec fib_par pool n =
	if n > 20 then begin
		let a = T.async pool (fun _ -> fib_par pool (n - 1)) in
			let b = T.async pool (fun _ -> fib_par pool (n - 2)) in
				T.await pool a + T.await pool b
	end else fib n
;;

let main num_domains =
  let pool = T.setup_pool ~num_domains:(num_domains - 1) () in
  let res = T.run pool (fun _ -> fib_par pool n) in
  T.teardown_pool pool;
  Printf.printf "fib(%d) = %d" n res;
;;

let nums_domains = [| 1; 2; 4; 8 |] in
	for i = 0 to 3 do
		let t = Unix.gettimeofday () in
			let _ = main nums_domains.(i) in
				Printf.printf "\nnombre de domaines : %d  durée : %0.4f secondes" nums_domains.(i) (Unix.gettimeofday () -. t);
				print_newline () 
	done
;;
