(* les nombres rationnels sont représentés par des couples de grands entiers *)
(* les fonctions affines x -> a/c + b/c x à coefficients rationnels sont *)
(* représentées par les triplets (a,b,c) de grands entiers *)

(* valeur en n grand entier de la fonction affine x->a/c + b/c x *)
let valeur (a, b, c) n = (*Printf.printf "valeur\n";*) Z.(a + b * n, c);;

(* composée de deux fonctions affines *)
let compose (a, b, c) (a', b', c') = Z.(a * c' + b * a', b * b', c * c');;

(* partie entière de 1O^n * a / (b * c) avec a et b des grands entiers positifs, c et n des int *)
let floor10 n c (a, b) = Z.(a * pow (of_int 10) n / (b * of_int c));;

(* simplification de la fraction num / den *)
let frac (num, den) = let x = Q.make num den in (x.num, x.den);;

(*-----------------------*)

let poly x = Z.(of_int 330 + x * (of_int 1804 + x * (of_int 3066 + x * of_int 1640)));;

let a n = poly Z.(of_int n);;

let b n =
	let num = ref Z.one and den = ref Z.one in
		for j = 4 * n + 1 to 4 * n + 4 do
			num := Z.(!num * of_int j);
			den := Z.(!den * (of_int j lsl 1 + of_int 7))
		done;
		(!num, Z.(- shift_left !den 6))
;;

let f n = (* fonction affine f n : x -> a n + b n * x *)
	let (bn, bd) = frac (b n) in Z.(a n * bd, bn, bd)
;;

let g n = (* composée f 0 (f 1( ... f n)) *)
	let rec aux a b =
		if a < b then
			let m = (a + b) / 2 in if m = a then f a
				else compose (aux a m) (aux m b)
		else failwith "aux"
	in
	aux 0 (n + 1);
	(* avec ocaml 5.0.0 on pourra mettre en commentaire la ligne précédente et décommenter les 5 lignes suivantes *)
	(*	let d1 = Domain.spawn (fun _ -> aux 0 (2 * n / 3)) in
			let d2 = Domain.spawn (fun _ -> aux (2 * n / 3) (n + 1)) in
				let r1 = Domain.join d1 in
					let r2 = Domain.join d2 in
						compose r1 r2 *)
;;

let pi n = (* n décimales de pi après sa partie entière *)
	let p = n / 3 in
		let t = Unix.gettimeofday () in
			let composee_affine = ref (g p) in
				let res = ref (floor10 n 105 (valeur !composee_affine Z.zero)) in
					Printf.printf "%d décimales de pi en %0.4f s\n" n (Unix.gettimeofday () -. t);
					((* Contrôle *)
						let t' = Unix.gettimeofday () in
							let res1 = ref (floor10 n 105 (valeur !composee_affine (a (p + 1)))) in
								let q = ref p in
									while !res <> !res1 do
										incr q;
										composee_affine := compose !composee_affine (f !q);
										res := !res1;
										res1 := floor10 n 105 (valeur !composee_affine (a (!q + 1)))
									done;
									if !q <> p then (
											Printf.printf "valeur corrigée";
											print_newline ();
											res := floor10 n 105 (valeur !composee_affine Z.zero)
										);
									Printf.printf "contrôle effectué en %0.2f s" (Unix.gettimeofday () -. t');
									print_newline ();
					);
					((* Enregistrement *)
						let filename = "pi-" ^ string_of_int n ^ ".txt" in
							let canalout = open_out filename in
								Z.output canalout !res;
								close_out canalout;
								Printf.printf "résultat dans le fichier \"%s\" du répertoire %s\n" filename (Unix.getcwd ());
					);
;;

pi 1000000;;
